local AL = AceLibrary("AceLocale-2.2"):new("AtlasLoot");

AL:RegisterTranslations("deDE", function() return {
    --Text strings for UI objects
    ["AtlasLoot"] = "AtlasLoot",   --ATLASLOOT_TITLE
    ["No match found for"] = "Kein Eintrag gefunden f\195\188r",  --ATLASLOOT_NOMATCH
    ["Search"] = "Suchen",  --ATLASLOOT_SEARCH
    ["Clear"] = "Leeren",  --ATLASLOOT_CLEAR
    ["Select Loot Table"] = "W\195\164hle Loot Rubrik",   --ATLASLOOT_DEFAULTFRAME_MENU
    ["Select Sub-Table"] = "W\195\164hle Unter-Rubrik",
    ["Drop Rate: "] = "Dropchance",  --ATLASLOOT_DROP_RATE
    ["DKP"] = "DKP",    --ATLASLOOT_DKP
    ["Priority:"] = "Priorit\195\164t:",  --ATLASLOOT_PRIORITY
    ["Click boss name to view loot."] = "Klicke Boss um den Loot zu sehen.",  --ATLASLOOT_BANNER_TEXT
    ["Various Locations"] = "Verschiedene Orte",   --ATLASLOOT_VARIOUS_LOC
    ["This is a loot browser only.  To view maps as well, install either Atlas or Alphamap."] = "Dies ist nur ein Loot-Browser. Falls du Karten m\195\182chtest installiere bitte 'Atlas' oder 'Alphamap'.",   --ATLASLOOT_DEFAULTFRAME_NOTICE
    ["Toggle AL Panel"] = "AL-Leiste ein/aus",   --ATLASLOOT_PANEL_TOGGLE
    [" is safe."] = " ist jetzt sicher.",  --ATLASLOOT_SAFE_MESSAGE
    ["Server queried for "] = "Fragt den Server nach ",  --ATLASLOOT_QUERY_MESSAGE
    [".  Right click on any other item to refresh the loot page."] = ".  Bitte klicke so lange auf das Item, bis diese Meldung nicht mehr erscheint.", --ATLASLOOT_RECLICK_MESSAGE
    ["Back"] = "Zur\195\188ck",  --ATLASLOOT_UIBACK
    ["Level 60"] = "Level 60", --ATLASLOOT_LEVEL_60
    ["Level 70"] = "Level 70",  --ATLASLOOT_LEVEL_70
    ["|cffff0000(unsafe)"] = " |cffff0000(unsicher)",  --ATLASLOOT_NO_ITEMINFO
    ["Misc"] = "Verschiedenes",  --ATLASLOOT_MISC
    ["Rewards"] = "Belohnungen",
    ["Heroic Mode"] = "Heroisch",  --ATLASLOOT_HEROIC
    ["Normal Mode"] = "Normal",  --ATLASLOOT_NORMAL
    ["Raid"] = "Raid",  --ATLASLOOT_RAID
    ["Factions - Azeroth"] = "Fraktionen - Azeroth",
    ["Factions - Outland"] = "Fraktionen - Scherbenwelt",
    ["Factions - Shattrath City"] = "Fraktionen - Shattrath",
    ["Pre-Burning Crusade"] = "Vor Burning Crusade",
    ["Post-Burning Crusade"] = "Nach Burning Crusade",
    ["Choose Table ..."] = "W\195\164hle Tabelle ...",
    ["Close Menu"] = "Schliese Men\195\188",
    
    --Text for Options Panel
    ["Atlasloot Options"] = "Atlasloot Optionen",  --ATLASLOOT_OPTIONS_TITLE
    ["Safe Chat Links |cff1eff00(recommended)|r"] = "Sichere Chatlinks |cff1eff00(empfohlen)|r",  --ATLASLOOT_OPTIONS_SAFE_LINKS
    ["Enable all Chat Links |cffff0000(use at own risk)|r"] = "Alle Chatlinks aktivieren |cffff0000(auf eigene Gefahr)|r",  --ATLASLOOT_OPTIONS_ALL_LINKS
    ["Default Tooltips"] = "Standard Tooltips", --ATLASLOOT_OPTIONS_DEFAULT_TOOLTIPS
    ["Lootlink Tooltips"] = "Lootlink Tooltips", --ATLASLOOT_OPTIONS_LOOTLINK_TOOLTIPS
    ["|cff9d9d9dLootlink Tooltips|r"] = "|cff9d9d9dLootlink Tooltips benutzen|r",  --ATLASLOOT_OPTIONS_LOOTLINK_TOOLTIPS_DISABLED
    ["ItemSync Tooltips"] = "ItemSync Tooltpis benutzen",  --ATLASLOOT_OPTIONS_ITEMSYNC_TOOLTIPS
    ["|cff9d9d9dItemSync Tooltips|r"] = "|cff9d9d9dItemSync Tooltips benutzen|r",  --ATLASLOOT_OPTIONS_ITEMSYNC_TOOLTIPS_DISABLED
    ["Use EquipCompare"] = "EquipCompare benutzen",  --ATLASLOOT_OPTIONS_EQUIPCOMPARE
    ["|cff9d9d9dUse EquipCompare|r"] = "|cff9d9d9dEquipCompare benutzen|r",  --ATLASLOOT_OPTIONS_EQUIPCOMPARE_DISABLED
    ["Show Comparison Tooltips"] = "Zeige eigenes Item zum Vergleich",
    ["Make Loot Table Opaque"] = "Macht den Hintergrund undurchsichtig",  --ATLASLOOT_OPTIONS_OPAQUE
    ["Show itemIDs at all times"] = "Item-IDs stets anzeigen",  --ATLASLOOT_OPTIONS_ITEMIDS
    ["Hide AtlasLoot Panel"] = "Die AtlasLoot-Leiste ausblenden",  --ATLASLOOT_OPTIONS_HIDEPANEL
    ["Show Minimap Button"] = "Zeigt einen Button an der Minimap",  --ATLASLOOT_OPTIONS_MINIMAP
    ["Set Minimap Button Position"] = "Ver\195\164ndert die Position des Buttons an der Minimap",  --ATLASLOOT_OPTIONS_MINIMAPPOS
    ["Suppress text spam when querying items"] = "Text-Spam bei Itemabfragen unterdr\195\188cken",
    ["Notify me when a LoD Module is loaded"] = "Benachrichtigungen beim Laden von Modulen",
    ["Load all loot modules at startup"] = "Alle Loot-Module direkt beim Start laden",
    ["Done"] = "OK",  --ATLASLOOT_OPTIONS_DONE
    
    --Minimap Button
    ["|cff1eff00Left-Click|r Browse Loot Tables"] = "|cff1eff00Linksklick:|r Loot-Tabellen durchsuchen",  --ATLASLOOT_MINIMAPBUTTON_LINE1
    ["|cffff0000Right-Click|r View Options"] = "|cffff0000Rechtsklick:|r Optionen anzeigen",  --ATLASLOOT_MINIMAPBUTTON_LINE2
    ["|cffff0000Shift-Click|r View Options"] = "|cffff0000SHIFT-Click|r Optionen anzeigen",  --ATLASLOOT_MINIMAPBUTTON_LINE2_ALT
    ["|cffccccccLeft-Click + Drag|r Move Minimap Button"] = "|cffccccccLinksklick + Ziehen|r Minimap-Button bewegen",  --ATLASLOOT_MINIMAPBUTTON_LINE3
    
    --AtlasLoot Panel
    ["Options"] = "Optionen",  --ATLASLOOT_PANEL_BUTTON_OPTIONS
    ["Collections"] = "Sammlungen", --ATLASLOOT_PANEL_BUTTON_SETS
    ["Factions"] = "Fraktionen",  --ATLASLOOT_PANEL_BUTTON_REPUTATION
    ["World Events"] = "Welt-Events",
    ["Load Modules"] = "Module laden",

    --First time user
    ["Welcome to Atlasloot Enhanced.  Please take a moment to set your preferences for tooltips and links in the chat window.\n\n  This options screen can be reached again at any later time by typing '/atlasloot'."] = "Willkommen zu Atlasloot Enhanced!  Bitte nimm dir einen Moment Zeit, um die Einstellungen f\195\188r Tooltips und Chatlinks festzulegen.\nWenn du sp\195\164ter etwas \195\164ndern willst, kannst du den Optionsbildschirm mit /atlasloot aufrufen.", --ATLASLOOT_FIRST_TIME_TEXT
    ["Setup"] = "Optionen",  --ATLASLOOT_FIRST_TIME_BUTTON
    
    --Old Atlas Detected
    ["It has been detected that your version of Atlas does not match the version that Atlasloot is tuned for ("] = "Atlasloot hat festgestellt, dass die Version von Atlas die du benutzt, nicht der Version entspricht f\195\188r die Atlasloot konzepiert ist(", --ATLASLOOT_OLD_ATLAS_TEXT_PT1
    [").  Depending on changes, there may be the occasional error, so please visit http://www.atlasmod.com as soon as possible to update."] = "). Dadurch k\195\182nnen (schwere) Fehler auftreten! Bitte besuch so schnell wie m\195\182glich http://www.atlasmod.com und lad dir die neuste Atlas Version runter.",  --ATLASLOOT_OLD_ATLAS_TEXT_PT2
    ["OK"] = "OK",   --ATLASLOOT_OLD_ATLAS_BUTTON
    ["Incompatible Atlas Detected"] = "Nicht kompatibles Atlas gefunden",
    
    --Unsafe item tooltip
    ["Unsafe Item"] = "Unsicheres Item", --ATLASLOOT_ERRORTOOLTIP_L1
    ["ItemID:"] = "Item-ID:",  --ATLASLOOT_ERRORTOOLTIP_L2
    ["This item is unsafe.  To view this item without the risk of disconnection, you need to have first seen it in the game world. This is a restriction enforced by Blizzard since Patch 1.10."] = "Diese Item ist unsicher.\nSobald du dieses Item ingame gesehen hast,\nbesteht nicht mehr die Gefahr eines Verbindungsabbruch\n(Es ist dann nicht mehr unsicher). Diese\nBestimmung wurde von Blizzard mit\nPatch 1.10 festgelegt.", --ATLASLOOT_ERRORTOOLTIP_L3
    ["You can right-click to attempt to query the server.  You may be disconnected."] = "Mit einem Rechtsklick wird der\nServer nach dem Item abgefragt, dabei\nk\195\182nnte die Verbindung unterbrochen werden.", --ATLASLOOT_ERRORTOOLTIP_L4

    --Misc Inventory related words
    ["Mount"] = "Reittier",  -- ATLASLOOT_MOUNT
    ["Enchant"] = "Verzauberung",  --ATLASLOOT_ENCHANT
    ["Trade Goods"] = "Handelswaren",  --ATLASLOOT_TRADE_GOODS
    ["Scope"] = "Zielfernrohr",  --ATLASLOOT_SCOPE
    ["Pet"] = "Haustier",  --ATLASLOOT_PET
    ["Darkmoon Faire Card"] = "Dunkelmond-Karte",  --ATLASLOOT_DARKMOON
    ["Book"] = "Buchband",  --ATLASLOOT_BOOK
    ["Banner"] = "Banner",  --ATLASLOOT_BANNER
    ["Set"] = "Set",  --ATLASLOOT_SET
    ["Token"] = "Gutschein",  --ATLASLOOT_TOKEN
    ["Crafting Reagent"] = "Reagenz", --ATLASLOOT_CRAFTING
    ["Skinning Knife"] = "K\195\188rschnermesser",
    ["Herbalism Knife"] = "Kr\195\164uterkundemesser",
    ["Fishing Pole"] = "Angel",
    ["Fish"] = "Fisch",

    --Labels for loot descriptions
    ["Classes:"] = "Klassen:",  --ATLASLOOT_CLASSES
    ["This Item Begins a Quest"] = "Dieser Gegenstand startet eine Quest",  --ATLASLOOT_ITEMBEGINSQUEST
    ["Quest Item"] = "Questgegenstand",  --ATLASLOOT_QUESTITEM
    ["Quest Reward"] = "Questbelohnung",  --ATLASLOOT_QUESTREWARD
    ["Shared"] = "geteilter Loot",  --ATLASLOOT_SHARED 
    ["Unique"] = "Einzigartig",  --ATLASLOOT_UNIQUE
    ["Right Half"] = "Rechte H\195\164lfte",  --ATLASLOOT_RIGHTSIDE
    ["Left Half"] = "Linke H\195\164lfte",  --ATLASLOOT_LEFTSIDE
    ["28 Slot Soul Shard"] = "28er-Beh\195\164lter Seelensplitter",  --ATLASLOOT_FELCOREBAG
    ["18 Slot"] = "18 Platz",  --ATLASLOOT_ONYBAG
    ["16 Slot"] = "16 Platz",  --ATLASLOOT_16SLOT
    ["10 Slot"] = "10 Platz",  --ATLASLOOT_WCBAG
    ["(has random enchantment)"] = "(zuf\195\164llige Verzauberung)",  --ATLASLOOT_RANDOM
    ["Use to purchase rewards"] = "Zum Kaufen von Belohnungen verwenden", --ATLASLOOT_TOKENS, ATLASLOOT_FACTION_ARGENT_INSIGNIAS
    ["Use to purchase rewards (Horde)"] = "Zum Kaufen von Belohnungen verwenden (Horde)",  --ATLASLOOT_TOKENS_HORDE
    ["Use to purchase rewards (Alliance)"] = "Zum Kaufen von Belohnungen verwenden (Allianz)",  --ATLASLOOT_TOKENS_ALLIANCE
    ["World Bosses"] = "Weltbosse",
    ["Reputation Factions"] = "Ruf-Fraktionen",
    ["Sets/Collections"] = "Sets/Sammlungen",
    ["Card Game Item"] = "Kartenspiel Item",
    ["Arena Reward"] = "Arena Belohnungen", 
    ["Conjured Item"] = "Verbrauchbar", 
    ["Used to summon boss"] = "Zur Beschw\195\182rung ben\195\182tigt (Boss)", 
    
    ["Fire"] = "Feuer", 
    ["Water"] = "Wasser", 
    ["Wind"] = "Wind", 
    ["Earth"] = "Erde", 
    ["Master Angler"] = "Anglermeister", 
    ["First Prize"] = "Hauptpreis", 
    ["Rare Fish Rewards"] = "Besonderer Fisch Belohnungen", 

    --Card Game Decks and descriptions
    ["Upper Deck Card Game Items"] = "Upper Deck Kartenspiel Items",
    ["Heroes of Azeroth"] = "Helden von Azeroth",
    ["Through The Dark Portal"] = "Durch das Dunkle Portal",
    ["Fires of Outland"] = "Feuer der Scherbenwelt",
    ["Loot Card Items"] = "Beutekarten Gegenst\195\164nde", 
    ["UDE Items"] = "UDE Gegenst\195\164nde",
    ["Landro Longshot"] = "Landro Fernblick",
    ["Thunderhead Hippogryph"] = "Donnerkopfhippogryph",
    ["Saltwater Snapjaw"] = "Salzwasserschnappkiefer",
    ["King Mukla"] = "K\195\182nig Mukla",
    ["Rest and Relaxation"] = "Ruhe und Entspannung",
    ["Fortune Telling"] = "Fortune Telling", -- localalization unknown
    
    --Special loot categories for Battlegrounds
    ["Misc. Rewards"] = "Diverses",  --ATLASLOOT_BG_MISC
    ["Superior Rewards"] = "Seltene Items", --ATLASLOOT_BG_BLUE
    ["Epic Rewards"] = "Epische Items",  --ATLASLOOT_BG_PURPLE
    
    --Brood Paths
    ["Path of the Conqueror"] = "Der Pfad des Eroberers", --ATLASLOOT_BROOD_CONQUEROR
    ["Path of the Invoker"] = "Der Pfad des Herbeirufers",  --ATLASLOOT_BROOD_INVOKER
    ["Path of the Protector"] = "Der Pfad des Besch\195\188tzers",  --ATLASLOOT_BROOD_PROTECTOR
    
    --Violet Eye Paths
    ["Path of the Violet Protector"] = "Violetter Besch\195\188tzer",  --ATLASLOOT_FACTION_VIOLETEYE_PROTECTOR
    ["Path of the Violet Mage"] = "Violetter Magier",  --ATLASLOOT_FACTION_VIOLETEYE_MAGE
    ["Path of the Violet Assassin"] = "Violetter Auftragsm\195\182rder",  --ATLASLOOT_FACTION_VIOLETEYE_ASSASSIN
    ["Path of the Violet Restorer"] = "Violetter Bewahrer",  --ATLASLOOT_FACTION_VIOLETEYE_RESTORER
    
    --AQ Opening Event
    ["Red Scepter Shard"] = "Roter Szeptersplitter",  --ATLASLOOT_RED_SCEPTER
    ["Blue Scepter Shard"] = "Blauer Szeptersplitter",  --ATLASLOOT_BLUE_SCEPTER
    ["Green Scepter Shard"] = "Gr\195\188ner Szeptersplitter",  --ATLASLOOT_GREEN_SCEPTER
    ["Scepter of the Shifting Sands"] = "Das Szepter der Sandst\195\188rme",  --ATLASLOOT_SCEPTER
    
    --World PvP
    ["Hellfire Fortifications"] = "Befestigung des H\195\182llenfeuers",  --ATLASLOOT_ZONE_HELLFIRE_W_PVP_AL
    ["Twin Spire Ruins"] = "Ruinen der Zwillingsspitze", --ATLASLOOT_ZONE_ZANGAR_W_PVP
    ["Spirit Towers"] = "Geistert\195\188rme",  --ATLASLOOT_ZONE_TEROKKAR_W_PVP
    ["Halaa"] = "Halaa",  --ATLASLOOT_ZONE_NAGRAND_W_PVP
    
    --Karazhan Opera Event Headings
    ["Shared Drops"] = "geteilter Loot",  --ATLASLOOT_KARAOPERA_SHARED
    ["Romulo & Julianne"] = "Romulo & Julianne", --ATLASLOOT_KARAOPERA_ROMEOANDJULIET
    ["Wizard of Oz"] = "Zauberer von Oz",  --ATLASLOOT_KARAOPERA_WIZARDOFOZ
    ["Red Riding Hood"] = "Rotk\195\164ppchen",  --ATLASLOOT_KARAOPERA_REDRIDINGHOOD
    
    --Karazhan Animal Boss Types
    ["Spider"] = "Spinne",  --ATLASLOOT_KARA_ANIMAL_1_TYPE
    ["Darkhound"] = "Schattenhund",  --ATLASLOOT_KARA_ANIMAL_2_TYPE
    ["Bat"] = "Fledermaus",  --ATLASLOOT_KARA_ANIMAL_3_TYPE

    --ZG Tokens
    ["Primal Hakkari Kossack"] = "Hakkarikosak", --ATLASLOOT_Primal_Hakkari_Kossack
    ["Primal Hakkari Shawl"] = "Hakkarischal",  --ATLASLOOT_Primal_Hakkari_Shawl
    ["Primal Hakkari Bindings"] = "Hakkaribindungen", --ATLASLOOT_Primal_Hakkari_Bindings
    ["Primal Hakkari Sash"] = "Hakkarisch\195\164rpe", --ATLASLOOT_Primal_Hakkari_Sash
    ["Primal Hakkari Stanchion"] = "Hakkarist\195\188tze", --ATLASLOOT_Primal_Hakkari_Stanchion
    ["Primal Hakkari Aegis"] = "Aegis der Hakkari",  --ATLASLOOT_Primal_Hakkari_Aegis
    ["Primal Hakkari Girdle"] = "Hakkarigurt", --ATLASLOOT_Primal_Hakkari_Girdle
    ["Primal Hakkari Armsplint"] = "Hakkariarmsplintes", --ATLASLOOT_Primal_Hakkari_Armsplint
    ["Primal Hakkari Tabard"] = "Hakkariwappenrock", --ATLASLOOT_Primal_Hakkari_Tabard
    
    --AQ20 Tokens
    ["Qiraji Ornate Hilt"] = "Verschn\195\182rkelter Griff", --ATLASLOOT_Qiraji_Ornate_Hilt
    ["Qiraji Martial Drape"] = "Kampftuch", --ATLASLOOT_Qiraji_Martial_Drape
    ["Qiraji Magisterial Ring"] = "Gebieterring",  --ATLASLOOT_Qiraji_Magisterial_Ring
    ["Qiraji Ceremonial Ring"] = "Zeremonienring",  --ATLASLOOT_Qiraji_Ceremonial_Ring
    ["Qiraji Regal Drape"] = "Hoheitstuch",   --ATLASLOOT_Qiraji_Regal_Drape
    ["Qiraji Spiked Hilt"] = "Stachelgriff",   --ATLASLOOT_Qiraji_Spiked_Hilt
    
    --AQ40 Tokens
    ["Qiraji Bindings of Dominance"] = "Dominanzbindungen", --ATLASLOOT_Qiraji_Bindings_of_Dominance
    ["Qiraji Bindings of Command"] = "Befehlsbindungen", --ATLASLOOT_Qiraji_Bindings_of_Command
    ["Vek'nilash's Circlet"] = "Vek'nilashs Reif",  --ATLASLOOT_Veknilashs_Circlet
    ["Vek'lor's Diadem"] = "Vek'lors Diadem",   --ATLASLOOT_Veklors_Diadem
    ["Ouro's Intact Hide"] = "Ouros intakte Haut",  --ATLASLOOT_Ouros_Intact_Hide
    ["Skin of the Great Sandworm"] = "Haut des Sandwurms",  --ATLASLOOT_Skin_of_the_Great_Sandworm
    ["Husk of the Old God"] = "H\195\188lle des Gottes",  --ATLASLOOT_Husk_of_the_Old_God
    ["Carapace of the Old God"] = "Knochenpanzer des Gottes",  --ATLASLOOT_Carapace_of_the_Old_God

    --Blacksmithing Crafted Sets
    ["Imperial Plate"] = "Stolz des Imperiums", --ATLASLOOT_CRAFTSET_IMPERIALPLATE
    ["The Darksoul"] = "Die dunkle Seele", --ATLASLOOT_CRAFTSET_DARKSOUL
    ["Fel Iron Plate"] = "Teufelseisenplattenr\195\188stung", --ATLASLOOT_CRAFTSET_FELIRONPLATE
    ["Adamantite Battlegear"] = "Adamantitschlachtr\195\188stung", --ATLASLOOT_CRAFTSET_ADAMANTITEB
    ["Flame Guard"] = "Flammenw\195\164chter", --ATLASLOOT_CRAFTSET_FLAMEGUARD
    ["Enchanted Adamantite Armor"] = "Verzauberte Adamantitr\195\188stung", --ATLASLOOT_CRAFTSET_ENCHANTEDADAMAN
    ["Khorium Ward"] = "Khoriumschutz", --ATLASLOOT_CRAFTSET_KHORIUM
    ["Faith in Felsteel"] = "Teufelsst\195\164hlerner Wille", --ATLASLOOT_CRAFTSET_FELSTEEL
    ["Burning Rage"] = "Brennernder Zorn", --ATLASLOOT_CRAFTSET_BURNINGRAGE
    ["Bloodsoul Embrace"] = "Umarmung der Blutseele", --ATLASLOOT_CRAFTSET_BLOODSOUL
    ["Fel Iron Chain"] = "Teufelseisenkettenr\195\188stung", --ATLASLOOT_CRAFTSET_FELIRONCHAIN

    --Tailoring Crafted Sets
    ["Bloodvine Garb"] = "Blutrebengewand", --ATLASLOOT_CRAFTSET_BLOODVINEGARB
    ["Netherweave Vestments"] = "Netherstoffgew\195\164nder", --ATLASLOOT_CRAFTSET_NEATHERVESTMENTS
    ["Imbued Netherweave"] = "Magieerf\195\188llte Netherstoffroben", --ATLASLOOT_CRAFTSET_IMBUEDNEATHER
    ["Arcanoweave Vestments"] = "Arkanostoffgew\195\164nder", --ATLASLOOT_CRAFTSET_ARCANOVEST
    ["The Unyielding"] = "Der Unersch\195\188tterliche", --ATLASLOOT_CRAFTSET_TUNYIELDING
    ["Whitemend Wisdom"] = "Weisheit des wei\195\159en Heilers", --ATLASLOOT_CRAFTSET_WHITEMENDWIS
    ["Spellstrike Infusion"] = "Insignien des Zauberschlags", --ATLASLOOT_CRAFTSET_SPELLSTRIKEINFU
    ["Battlecast Garb"] = "Gewand des Schlachtenzaubers", --ATLASLOOT_CRAFTSET_BATTLECASTG
    ["Soulcloth Embrace"] = "Seelenstoffumarmung", --ATLASLOOT_CRAFTSET_SOULCLOTHEMBRACE
    ["Primal Mooncloth"] = "Urmondroben", --ATLASLOOT_CRAFTSET_PRIMALMOON
    ["Shadow's Embrace"] = "Umarmung der Schatten", --ATLASLOOT_CRAFTSET_SHADOWEMBRACE
    ["Wrath of Spellfire"] = "Zorn des Zauberfeuers", --ATLASLOOT_CRAFTSET_WRATHSPELLFIRE

    --Leatherworking Crafted Sets
    ["Volcanic Armor"] = "Vulkanr\195\188stung", --ATLASLOOT_CRAFTSET_VOLCANICA
    ["Ironfeather Armor"] = "Eisenfederr\195\188stung", --ATLASLOOT_CRAFTSET_IRONFEATHER
    ["Stormshroud Armor"] = "Sturmschleier", --ATLASLOOT_CRAFTSET_STORMSHROUD
    ["Devilsaur Armor"] = "Teufelsaurierr\195\188stung", --ATLASLOOT_CRAFTSET_DEVILARMOR 
    ["Blood Tiger Harness"] = "Harnisch des Bluttigers", --ATLASLOOT_CRAFTSET_BLOODTIGER 
    ["Primal Batskin"] = "Urzeitliche Fledermaushaut", --ATLASLOOT_CRAFTSET_BATSKINA 
    ["Wild Draenish Armor"] = "Wilde draenische R\195\188stung", --ATLASLOOT_CRAFTSET_WILDDRAENI 
    ["Thick Draenic Armor"] = "Dicke draenische R\195\188stung", --ATLASLOOT_CRAFTSET_THICKDREANI 
    ["Fel Skin"] = "Teufelshaut", --ATLASLOOT_CRAFTSET_FELSKIN 
    ["Strength of the Clefthoof"] = "Macht der Grollhufe", --ATLASLOOT_CRAFTSET_SCLEFTHOOF 
    ["Green Dragon Mail"] = "Gr\195\188ner Drachenschuppenpanzer", --ATLASLOOT_CRAFTSET_GREENDRAGONM 
    ["Blue Dragon Mail"] = "Blauer Drachenschuppenpanzer", --ATLASLOOT_CRAFTSET_BLUEDRAGONM 
    ["Black Dragon Mail"] = "Schwarzer Drachenschuppenpanzer", --ATLASLOOT_CRAFTSET_BLACKDRAGONM 
    ["Scaled Draenic Armor"] = "Geschuppte draenische R\195\188stung", --ATLASLOOT_CRAFTSET_SACLEDDREANI
    ["Felscale Armor"] = "Teufelsschuppenr\195\188stung", --ATLASLOOT_CRAFTSET_FELSCALEA
    ["Felstalker Armor"] = "R\195\188stung des Teufelspirschers", --ATLASLOOT_CRAFTSET_FELSTALKERA 
    ["Fury of the Nether"] = "Netherzorn", --ATLASLOOT_CRAFTSET_NEATHERFURY 
    ["Primal Intent"] = "Urinstinkt", --ATLASLOOT_CRAFTSET_PRIMALINTENT 
    ["Windhawk Armor"] = "R\195\188stung des Windfalken", --ATLASLOOT_CRAFTSET_WINDHAWKA 
    ["Netherscale Armor"] = "Netherschuppenr\195\188stung", --ATLASLOOT_CRAFTSET_NEATHERSCALEA 
    ["Netherstrike Armor"] = "R\195\188stung des Nethersto\195\159es", --ATLASLOOT_CRAFTSET_NEATHERSTRIKEA

    --Pre-60 Sets
    ["Defias Leather"] = "Defiasleder", --ATLASLOOT_PRE60_DEADMINES 
    ["Embrace of the Viper"] = "Umarmung der Viper", --ATLASLOOT_PRE60_WAILING
    ["Chain of the Scarlet Crusade"] = "Kettenr\195\188stung des Scharlachroten Kreuzzugs", --ATLASLOOT_PRE60_SCARLET
    ["The Gladiator"] = "Der Gladiator", --ATLASLOOT_PRE60_BLACKROCKD
    ["Ironweave Battlesuit"] = "Eisengewebte Kampfr\195\188stung", --ATLASLOOT_PRE60_IRONWEAVE
    ["Necropile Raiment"] = "Roben des Totenbeschw\195\182rers", --ATLASLOOT_PRE60_NECROPILE
    ["Cadaverous Garb"] = "Leichenhaftes Gewand", --ATLASLOOT_PRE60_CADAVEROUS
    ["Bloodmail Regalia"] = "Ornat des Blutpanzers", --ATLASLOOT_PRE60_BLOODMAIL
    ["Deathbone Guardian"] = "W\195\164chter der Totengebeine", --ATLASLOOT_PRE60_DEATHBONE
    ["The Postmaster"] = "Der Postmeister", --ATLASLOOT_PRE60_STRAT
    ["Scourge Invasion"] = "Invasion der Gei\195\159el", --ATLASLOOT_PRE60_SCOURGEINVASION
    ["Regalia of Undead Cleansing"] = "Ornat der Untotenbek\195\164mpfung", --ATLASLOOT_PRE60_UNDEADCLOTH
    ["Undead Slayer's Armor"] = "R\195\188stung des Untotenschl\195\164chters", --ATLASLOOT_PRE60_UNDEADLEATHER
    ["Garb of the Undead Slayer"] = "Gewand des Untotenschl\195\164chters", --ATLASLOOT_PRE60_UNDEADMAIL
    ["Battlegear of Undead Slaying"] = "Kampfr\195\188stung des Untotenschlachtens", --ATLASLOOT_PRE60_UNDEADPLATE
    ["Shard of the Gods"] = "Scherbe der G\195\182tter", --ATLASLOOT_PRE60_SHARDOFGODS
    ["Zul'Gurub Rings"] = "Zul'Gurub Ringe" , --ATLASLOOT_PRE60_ZGRINGS
    ["Major Mojo Infusion"] = "Kraft des Mojo", --ATLASLOOT_PRE60_MOJOINFUSION
    ["Overlord's Resolution"] = "Erlass des Oberherren", --ATLASLOOT_PRE60_OVERLORDRESO
    ["Prayer of the Primal"] = "Gebet der Uralten", --ATLASLOOT_PRE60_PRIMALPRAYER
    ["Zanzil's Concentration"] = "Zanzils Konzentration", --ATLASLOOT_PRE60_ZANZILCON
    ["Spirit of Eskhandar"] = "Seele des Eskhandar", --ATLASLOOT_PRE60_SPIRITOFESKHANDAR
    ["The Twin Blades of Hakkari"] = "Die Zwillingsklingen von Hakkari", --ATLASLOOT_PRE60_HAKKARIBLADES
    ["Primal Blessing"] = "Ursegen", --ATLASLOOT_PRE60_PRIMALBLESSING
    ["Dal'Rend's Arms"] = "Dal'Rends Waffen", --ATLASLOOT_PRE60_DALREND
    ["Spider's Kiss"] = "Kuss der Spinne", --ATLASLOOT_PRE60_SPIDERKISS

    --BC Sets
    ["The Twin Stars"] = "Die Zwillingssterne",
    ["The Twin Blades of Azzinoth"] = "Die Zwillingsklingen von Azzinoth",

    --ZG Sets
    ["Haruspex's Garb"] = "Gewand des Haruspex", --ATLASLOOT_ZG_DRUID 
    ["Predator's Armor"] = "R\195\188stung des Raubtiers", --ATLASLOOT_ZG_HUNTER 
    ["Illusionist's Attire"] = "Roben des Illusionisten", --ATLASLOOT_ZG_MAGE 
    ["Freethinker's Armor"] = "R\195\188stung des Freidenkers", --ATLASLOOT_ZG_PALADIN 
    ["Confessor's Raiment"] = "Gewand des Glaubensh\195\188ters", --ATLASLOOT_ZG_PRIEST 
    ["Madcap's Outfit"] = "R\195\188stzeug des Wildfangs", --ATLASLOOT_ZG_ROGUE 
    ["Augur's Regalia"] = "Ornat des Weissagers", --ATLASLOOT_ZG_SHAMAN 
    ["Demoniac's Threads"] = "Roben des Besessenen", --ATLASLOOT_ZG_WARLOCK
    ["Vindicator's Battlegear"] = "Schlachtr\195\188stung des Vollstreckers", --ATLASLOOT_ZG_WARRIOR 

    --AQ20 Sets
    ["Symbols of Unending Life"] = "Symbole des endlosen Lebens", --ATLASLOOT_AQ20_DRUID 
    ["Trappings of the Unseen Path"] = "Zierat des unsichtbaren Pfades", --ATLASLOOT_AQ20_HUNTER 
    ["Trappings of Vaulted Secrets"] = "Zierat der beh\195\188teten Geheimnisse", --ATLASLOOT_AQ20_MAGE 
    ["Battlegear of Eternal Justice"] = "Schlachtr\195\188stung der ewigen Gerechtigkeit", --ATLASLOOT_AQ20_PALADIN 
    ["Finery of Infinite Wisdom"] = "Pracht der unendlichen Weisheit", --ATLASLOOT_AQ20_PRIEST 
    ["Emblems of Veiled Shadows"] = "Embleme der Schattenschleier", --ATLASLOOT_AQ20_ROGUE 
    ["Gift of the Gathering Storm"] = "Gabe der aufziehenden St\195\188rme", --ATLASLOOT_AQ20_SHAMAN 
    ["Implements of Unspoken Names"] = "Ritualroben des ungesagten Namens", --ATLASLOOT_AQ20_WARLOCK 
    ["Battlegear of Unyielding Strength"] = "Schlachtr\195\188stung der unnachgiebigen St\195\164rke", --ATLASLOOT_AQ20_WARRIOR 

    --AQ40 Sets
    ["Genesis Raiment"] = "Gewandung der Genesis", --ATLASLOOT_AQ40_DRUID 
    ["Striker's Garb"] = "Gewand des Hetzers", --ATLASLOOT_AQ40_HUNTER 
    ["Enigma Vestments"] = "Gew\195\164nder des Mysteriums", --ATLASLOOT_AQ40_MAGE 
    ["Avenger's Battlegear"] = "Schlachtr\195\188stung des R\195\164chers", --ATLASLOOT_AQ40_PALADIN 
    ["Garments of the Oracle"] = "Gew\195\164nder des Orakels", --ATLASLOOT_AQ40_PRIEST 
    ["Deathdealer's Embrace"] = "Umarmung des Todesboten", --ATLASLOOT_AQ40_ROGUE 
    ["Stormcaller's Garb"] = "Gewand des Sturmrufers", --ATLASLOOT_AQ40_SHAMAN 
    ["Doomcaller's Attire"] = "Roben des Verdammnisrufers", --ATLASLOOT_AQ40_WARLOCK 
    ["Conqueror's Battlegear"] = "Schlachtr\195\188stung des Eroberers", --ATLASLOOT_AQ40_WARRIOR

    --Dungeon 1 Sets
    ["Wildheart Raiment"] = "Herz der Wildnis", --ATLASLOOT_T0_DRUID 
    ["Beaststalker Armor"] = "R\195\188stung des Bestienj\195\164gers", --ATLASLOOT_T0_HUNTER 
    ["Magister's Regalia"] = "Ornat des Magisters", --ATLASLOOT_T0_MAGE 
    ["Lightforge Armor"] = "Esse des Lichts", --ATLASLOOT_T0_PALADIN 
    ["Vestments of the Devout"] = "Gew\195\164nder des Gl\195\164ubigen", --ATLASLOOT_T0_PRIEST 
    ["Shadowcraft Armor"] = "R\195\188stung der Schattenkunst", --ATLASLOOT_T0_ROGUE 
    ["The Elements"] = "Die Elemente", --ATLASLOOT_T0_SHAMAN 
    ["Dreadmist Raiment"] = "Nebel der Furcht", --ATLASLOOT_T0_WARLOCK 
    ["Battlegear of Valor"] = "Schlachtr\195\188stung der Ehre", --ATLASLOOT_T0_WARRIOR

    --Dungeon 2 Sets
    ["Feralheart Raiment"] = "Ungez\195\164hmtes Herz", --ATLASLOOT_T05_DRUID 
    ["Beastmaster Armor"] = "R\195\188stung der Tierherrschaft", --ATLASLOOT_T05_HUNTER 
    ["Sorcerer's Regalia"] = "Ornat der Zauberk\195\188nste", --ATLASLOOT_T05_MAGE 
    ["Soulforge Armor"] = "R\195\188stung der Seelenschmiede", --ATLASLOOT_T05_PALADIN 
    ["Vestments of the Virtuous"] = "Gew\195\164nder des Tugendhaften", --ATLASLOOT_T05_PRIEST 
    ["Darkmantle Armor"] = "R\195\188stung der Finsternis", --ATLASLOOT_T05_ROGUE 
    ["The Five Thunders"] = "Die f\195\188nf Donner", --ATLASLOOT_T05_SHAMAN 
    ["Deathmist Raiment"] = "Roben des Todesnebels", --ATLASLOOT_T05_WARLOCK 
    ["Battlegear of Heroism"] = "Schlachtr\195\188stung des Heldentums", --ATLASLOOT_T05_WARRIOR

    --Dungeon 3 Sets
    ["Hallowed Raiment"] = "Geheiligte Roben", --ATLASLOOT_DS3_HALLOWED 
    ["Incanter's Regalia"] = "Ornat des Beschw\195\182rens", --ATLASLOOT_DS3_INCANTER 
    ["Mana-Etched Regalia"] = "Managetr\195\164nktes Ornat", --ATLASLOOT_DS3_MANA 
    ["Oblivion Raiment"] = "Gewandung des Vergessens", --ATLASLOOT_DS3_OBLIVION 
    ["Assassination Armor"] = "R\195\188stung des Meuchelmords", --ATLASLOOT_DS3_ASSASSIN 
    ["Moonglade Raiment"] = "Gewandung der Mondlichtung", --ATLASLOOT_DS3_MOONGLADE 
    ["Wastewalker Armor"] = "\195\150dniswandlerr\195\188stung", --ATLASLOOT_DS3_WASTEWALKER 
    ["Beast Lord Armor"] = "R\195\188stung des Wildtierf\195\188rsten", --ATLASLOOT_DS3_BEAST 
    ["Desolation Battlegear"] = "Schlachtr\195\188stung der Verw\195\188stung", --ATLASLOOT_DS3_DESOLATION
    ["Tidefury Raiment"] = "Gewandung des Gezeitensturms", --ATLASLOOT_DS3_TIDEFURY 
    ["Bold Armor"] = "R\195\188stung des Wagemutigen", --ATLASLOOT_DS3_BOLD 
    ["Doomplate Battlegear"] = "Verdammnisplattenr\195\188stung", --ATLASLOOT_DS3_DOOM 
    ["Righteous Armor"] = "R\195\188stung des Rechtschaffenen", --ATLASLOOT_DS3_RIGHT 

    --Tier 1 Sets
    ["Cenarion Raiment"] = "Gew\195\164nder des Cenarius", --ATLASLOOT_T1_DRUID 
    ["Giantstalker Armor"] = "R\195\188stung des Riesenj\195\164gers", --ATLASLOOT_T1_HUNTER 
    ["Arcanist Regalia"] = "Ornat des Arkanisten", --ATLASLOOT_T1_MAGE 
    ["Lawbringer Armor"] = "R\195\188stung der Gerechtigkeit", --ATLASLOOT_T1_PALADIN 
    ["Vestments of Prophecy"] = "Gew\195\164nder der Prophezeihung", --ATLASLOOT_T1_PRIEST 
    ["Nightslayer Armor"] = "Der Nachtmeuchler", --ATLASLOOT_T1_ROGUE 
    ["The Earthfury"] = "Die Wut der Erde", --ATLASLOOT_T1_SHAMAN 
    ["Felheart Raiment"] = "Teufelsherzroben", --ATLASLOOT_T1_WARLOCK 
    ["Battlegear of Might"] = "Schlachtr\195\188stung der Macht", --ATLASLOOT_T1_WARRIOR

    --Tier 2 Sets
    ["Stormrage Raiment"] = "Sturmgrimms Gew\195\164nder", --ATLASLOOT_T2_DRUID 
    ["Dragonstalker Armor"] = "R\195\188stung des Drachenj\195\164gers", --ATLASLOOT_T2_HUNTER 
    ["Netherwind Regalia"] = "Ornat des Netherwinds", --ATLASLOOT_T2_MAGE 
    ["Judgement Armor"] = "R\195\188stung des Richturteils", --ATLASLOOT_T2_PALADIN 
    ["Vestments of Transcendence"] = "Gew\195\164nder der Erhabenheit", --ATLASLOOT_T2_PRIEST 
    ["Bloodfang Armor"] = "Blutfangr\195\188stung", --ATLASLOOT_T2_ROGUE 
    ["The Ten Storms"] = "Die zehn St\195\188rme", --ATLASLOOT_T2_SHAMAN 
    ["Nemesis Raiment"] = "Roben der Nemesis", --ATLASLOOT_T2_WARLOCK 
    ["Battlegear of Wrath"] = "Schlachtr\195\188stung des Zorns", --ATLASLOOT_T2_WARRIOR

    --Tier 3 Sets
    ["Dreamwalker Raiment"] = "Gewandung des Traumwandlers", --ATLASLOOT_T3_DRUID 
    ["Cryptstalker Armor"] = "R\195\188stung des Gruftpirschers", --ATLASLOOT_T3_HUNTER 
    ["Frostfire Regalia"] = "Frostfeuerornat", --ATLASLOOT_T3_MAGE 
    ["Redemption Armor"] = "R\195\188stung der Erl\195\182sung", --ATLASLOOT_T3_PALADIN 
    ["Vestments of Faith"] = "Gew\195\164nder des Glaubens", --ATLASLOOT_T3_PRIEST 
    ["Bonescythe Armor"] = "R\195\188stung der Knochensense", --ATLASLOOT_T3_ROGUE 
    ["The Earthshatterer"] = "Der Erdspalter", --ATLASLOOT_T3_SHAMAN 
    ["Plagueheart Raiment"] = "Roben des verseuchten Herzens", --ATLASLOOT_T3_WARLOCK 
    ["Dreadnaught's Battlegear"] = "Schlachtr\195\188stung des Schreckenspanzers", --ATLASLOOT_T3_WARRIOR

    --Tier 4 Sets
    ["Malorne Harness"] = "Malornes Harnisch", --ATLASLOOT_T4_DRUID_1 
    ["Malorne Raiment"] = "Malornes Gewandung", --ATLASLOOT_T4_DRUID_2 
    ["Malorne Regalia"] = "Malornes Ornat", --ATLASLOOT_T4_DRUID_3 
    ["Demon Stalker Armor"] = "R\195\188stung des D\195\164monenwandlers", --ATLASLOOT_T4_HUNTER 
    ["Aldor Regalia"] = "Ornat der Aldor", --ATLASLOOT_T4_MAGE 
    ["Justicar Armor"] = "R\195\188stung des Rechtsprechers", --ATLASLOOT_T4_PALADIN_1 
    ["Justicar Battlegear"] = "Schlachtr\195\188stung des Rechtsprechers", --ATLASLOOT_T4_PALADIN_2 
    ["Justicar Raiment"] = "Gewandung des Rechtsprechers", --ATLASLOOT_T4_PALADIN_3 
    ["Incarnate Raiment"] = "Gewandung des Leibhaftigen", --ATLASLOOT_T4_PRIEST_1 
    ["Incarnate Regalia"] = "Ornat des Leibhaftigen", --ATLASLOOT_T4_PRIEST_2 
    ["Netherblade Set"] = "Netherklinge", --ATLASLOOT_T4_ROGUE 
    ["Cyclone Harness"] = "Harnisch des Orkans", --ATLASLOOT_T4_SHAMAN_1 
    ["Cyclone Raiment"] = "Gewandung des Orkans", --ATLASLOOT_T4_SHAMAN_2 
    ["Cyclone Regalia"] = "Ornat des Orkans", --ATLASLOOT_T4_SHAMAN_3 
    ["Voidheart Raiment"] = "Gewandung des Herzens der Leere", --ATLASLOOT_T4_WARLOCK 
    ["Warbringer Armor"] = "R\195\188stung des Kriegshetzers", --ATLASLOOT_T4_WARRIOR_1 
    ["Warbringer Battlegear"] = "Schlachtr\195\188stung des Kriegshetzers", --ATLASLOOT_T4_WARRIOR_2 

    --Tier 5 Sets
    ["Nordrassil Harness"] = "Harnisch von Nordrassil", --ATLASLOOT_T5_DRUID_1 
    ["Nordrassil Raiment"] = "Gewandung von Nordrassil", --ATLASLOOT_T5_DRUID_2 
    ["Nordrassil Regalia"] = "Ornat von Nordrassil", --ATLASLOOT_T5_DRUID_3 
    ["Rift Stalker Armor"] = "R\195\188stung des Dimensionswandlers", --ATLASLOOT_T5_HUNTER 
    ["Tirisfal Regalia"] = "Ornat von Tirisfal", --ATLASLOOT_T5_MAGE 
    ["Crystalforge Armor"] = "Kristallgeschmiedete R\195\188stung", --ATLASLOOT_T5_PALADIN_1 
    ["Crystalforge Battlegear"] = "Kristallgeschmiedete Schlachtr\195\188stung", --ATLASLOOT_T5_PALADIN_2 
    ["Crystalforge Raiment"] = "Kristallgeschmiedete Gewandung", --ATLASLOOT_T5_PALADIN_3 
    ["Avatar Raiment"] = "Gewandung des Avatars", --ATLASLOOT_T5_PRIEST_1 
    ["Avatar Regalia"] = "Ornat des Avatars", --ATLASLOOT_T5_PRIEST_2 
    ["Deathmantle Set"] = "Todeshauch", --ATLASLOOT_T5_ROGUE 
    ["Cataclysm Harness"] = "Harnisch der Verheerung", --ATLASLOOT_T5_SHAMAN_1 
    ["Cataclysm Raiment"] = "Gewandung der Verheerung", --ATLASLOOT_T5_SHAMAN_2 
    ["Cataclysm Regalia"] = "Ornat der Verheerung", --ATLASLOOT_T5_SHAMAN_3 
    ["Corruptor Raiment"] = "Gewandung des Verderbers", --ATLASLOOT_T5_WARLOCK 
    ["Destroyer Armor"] = "R\195\188stung des Zerst\195\182rers", --ATLASLOOT_T5_WARRIOR_1 
    ["Destroyer Battlegear"] = "Schlachtr\195\188stung des Zerst\195\182rers", --ATLASLOOT_T5_WARRIOR_2

    --Tier 6 Sets
    ["Thunderheart Harness"] = "Harnisch des Donnerherzens", --ATLASLOOT_T6_DRUID_1 
    ["Thunderheart Raiment"] = "Gewandung des Donnerherzens", --ATLASLOOT_T6_DRUID_2 
    ["Thunderheart Regalia"] = "Ornat des Donnerherzens", --ATLASLOOT_T6_DRUID_3 
    ["Gronnstalker's Armor"] = "R\195\188stung des Gronnpirschers", --ATLASLOOT_T6_HUNTER 
    ["Tempest Regalia"] = "Ornat des Gewittersturms", --ATLASLOOT_T6_MAGE 
    ["Lightbringer Armor"] = "R\195\188stung des Lichtbringers", --ATLASLOOT_T6_PALADIN_1 
    ["Lightbringer Battlegear"] = "Schlachtr\195\188stung des Lichtbringers", --ATLASLOOT_T6_PALADIN_2 
    ["Lightbringer Raiment"] = "Gewandung des Lichtbringers", --ATLASLOOT_T6_PALADIN_3 
    ["Vestments of Absolution"] = "Ornat der Absolution", --ATLASLOOT_T6_PRIEST_1 
    ["Absolution Regalia"] = "Gew\195\164nder der Absolution", --ATLASLOOT_T6_PRIEST_2 
    ["Slayer's Armor"] = "R\195\188stung des Schl\195\164chters", --ATLASLOOT_T6_ROGUE 
    ["Skyshatter Harness"] = "Harnisch des Himmelsdonners", --ATLASLOOT_T6_SHAMAN_1 
    ["Skyshatter Raiment"] = "Gewandung des Himmelsdonners", --ATLASLOOT_T6_SHAMAN_2 
    ["Skyshatter Regalia"] = "Ornat des Himmelsdonners", --ATLASLOOT_T6_SHAMAN_3 
    ["Malefic Raiment"] = "Gewandung der Boshaftigkeit", --ATLASLOOT_T6_WARLOCK 
    ["Onslaught Armor"] = "R\195\188stung des Ansturms", --ATLASLOOT_T6_WARRIOR_1 
    ["Onslaught Battlegear"] = "Schlachtr\195\188stung des Ansturms", --ATLASLOOT_T6_WARRIOR_2

    --Arathi Basin Sets - Alliance
    ["The Highlander's Intent"] = "Brennender Eifer des Highlanders", --ATLASLOOT_AB_ACLOTH 
    ["The Highlander's Purpose"] = "Schicksalsmacht des Highlanders", --ATLASLOOT_AB_ALEATHER1 
    ["The Highlander's Will"] = "Feuriger Wille des Highlanders", --ATLASLOOT_AB_ALEATHER2 
    ["The Highlander's Determination"] = "Inbrunst des Highlanders", --ATLASLOOT_AB_AMAIL 
    ["The Highlander's Resolve"] = "Entschlossenheit des Highlanders", --ATLASLOOT_AB_APLATE1 
    ["The Highlander's Resolution"] = "Unbeugsamkeit des Highlanders", --ATLASLOOT_AB_APLATE2 
    
    --Arathi Basin Sets - Horde
    ["The Defiler's Intent"] = "Brennender Eifer der Entweihten", --ATLASLOOT_AB_HCLOTH 
    ["The Defiler's Purpose"] = "Schicksalsmacht der Entweihten", --ATLASLOOT_AB_HLEATHER1 
    ["The Defiler's Will"] = "Feuriger Wille der Entweihten", --ATLASLOOT_AB_HLEATHER2 
    ["The Defiler's Determination"] = "Inbrunst der Entweihten", --ATLASLOOT_AB_HMAIL1 
    ["The Defiler's Fortitude"] = "Seelenkraft der Entweihten", --ATLASLOOT_AB_HMAIL2 
    ["The Defiler's Resolution"] = "Unbeugsamkeit der Entweihten", --ATLASLOOT_AB_HPLATE 

    --PvP Level 60 Rare Sets - Alliance
    ["Lieutenant Commander's Refuge"] = "Haingewand des Feldkommandanten", --ATLASLOOT_PVP_RARE_A_DRUID 
    ["Lieutenant Commander's Pursuance"] = "Jagdr\195\188stung des Feldkommandanten", --ATLASLOOT_PVP_RARE_A_HUNTER 
    ["Lieutenant Commander's Arcanum"] = "Arkanum des Feldkommandanten", --ATLASLOOT_PVP_RARE_A_MAGE 
    ["Lieutenant Commander's Redoubt"] = "Zeremonienr\195\188stung des Feldkommandanten", --ATLASLOOT_PVP_RARE_A_PALADIN 
    ["Lieutenant Commander's Investiture"] = "W\195\188rdengewand des Feldkommandanten", --ATLASLOOT_PVP_RARE_A_PRIEST 
    ["Lieutenant Commander's Guard"] = "Gew\195\164nder des Feldkommandanten", --ATLASLOOT_PVP_RARE_A_ROGUE 
    ["Lieutenant Commander's Stormcaller"] = "Sturmornat des Feldkommandanten", --ATLASLOOT_PVP_RARE_A_SHAMAN 
    ["Lieutenant Commander's Dreadgear"] = "Schreckensr\195\188stung des Feldkommandanten", --ATLASLOOT_PVP_RARE_A_WARLOCK 
    ["Lieutenant Commander's Battlearmor"] = "Sturmr\195\188stung des Feldkommandanten", --ATLASLOOT_PVP_RARE_A_WARRIOR 

    --PvP Level 60 Rare Sets - Horde
    ["Champion's Refuge"] = "Haingewand des Feldherren", --ATLASLOOT_PVP_RARE_H_DRUID 
    ["Champion's Pursuance"] = "Jagdr\195\188stung des Feldherren", --ATLASLOOT_PVP_RARE_H_HUNTER 
    ["Champion's Arcanum"] = "Arkanum des Feldherren", --ATLASLOOT_PVP_RARE_H_MAGE 
    ["Champion's Redoubt"] = "Zeremonier\195\188stung des Feldherren", --ATLASLOOT_PVP_RARE_H_PALADIN 
    ["Champion's Investiture"] = "W\195\188rdengewand des Feldherren", --ATLASLOOT_PVP_RARE_H_PRIEST 
    ["Champion's Guard"] = "Gew\195\164nder des Feldherren", --ATLASLOOT_PVP_RARE_H_ROGUE 
    ["Champion's Stormcaller"] = "Sturmornat des Feldherren", --ATLASLOOT_PVP_RARE_H_SHAMAN 
    ["Champion's Dreadgear"] = "Schreckensr\195\188stung des Feldherren", --ATLASLOOT_PVP_RARE_H_WARLOCK 
    ["Champion's Battlearmor"] = "Sturmr\195\188stung des Feldherren", --ATLASLOOT_PVP_RARE_H_WARRIOR
   
    --PvP Level 60 Epic Sets - Alliance
    ["Field Marshal's Sanctuary"] = "Zierat des Feldmarschalls", --ATLASLOOT_PVP_EPIC_A_DRUID 
    ["Field Marshal's Pursuit"] = "Lohn des Feldmarschalls", --ATLASLOOT_PVP_EPIC_A_HUNTER 
    ["Field Marshal's Regalia"] = "Ornat des Feldmarschalls", --ATLASLOOT_PVP_EPIC_A_MAGE 
    ["Field Marshal's Aegis"] = "Aegis des Feldmarschalls", --ATLASLOOT_PVP_EPIC_A_PALADIN 
    ["Field Marshal's Raiment"] = "Gewandung des Feldmarschalls", --ATLASLOOT_PVP_EPIC_A_PRIEST 
    ["Field Marshal's Vestments"] = "Gew\195\164nder des Feldmarschalls", --ATLASLOOT_PVP_EPIC_A_ROGUE 
    ["Field Marshal's Earthshaker"] = "Erdersch\195\188tterer des Feldmarschalls", --ATLASLOOT_PVP_EPIC_A_SHAMAN 
    ["Field Marshal's Threads"] = "Roben des Feldmarschalls", --ATLASLOOT_PVP_EPIC_A_WARLOCK 
    ["Field Marshal's Battlegear"] = "Schlachtr\195\188stung des Feldmarschalls", --ATLASLOOT_PVP_EPIC_A_WARRIOR

    --PvP Level 60 Epic Sets - Horde
    ["Warlord's Sanctuary"] = "Zierat des Kriegsf\195\188rsten", --ATLASLOOT_PVP_EPIC_H_DRUID 
    ["Warlord's Pursuit"] = "Lohn des des Kriegsf\195\188rsten", --ATLASLOOT_PVP_EPIC_H_HUNTER 
    ["Warlord's Regalia"] = "Ornat des Kriegsf\195\188rsten", --ATLASLOOT_PVP_EPIC_H_MAGE 
    ["Warlord's Aegis"] = "Aegis des Kriegsf\195\188rsten", --ATLASLOOT_PVP_EPIC_H_PALADIN 
    ["Warlord's Raiment"] = "Gewandung des Kriegsf\195\188rsten", --ATLASLOOT_PVP_EPIC_H_PRIEST 
    ["Warlord's Vestments"] = "Gew\195\164nder des Kriegsf\195\188rsten", --ATLASLOOT_PVP_EPIC_H_ROGUE 
    ["Warlord's Earthshaker"] = "Erdersch\195\188tterer des Kriegsf\195\188rsten", --ATLASLOOT_PVP_EPIC_H_SHAMAN 
    ["Warlord's Threads"] = "Roben des Kriegsf\195\188rsten", --ATLASLOOT_PVP_EPIC_H_WARLOCK 
    ["Warlord's Battlegear"] = "Schlachtr\195\188stung des Kriegsf\195\188rsten", --ATLASLOOT_PVP_EPIC_H_WARRIOR

    --PvP Level 70 Rare Sets - Alliance
    ["Grand Marshal's Sanctuary"] = "Schutzgewandung des Gro\195\159marschalls", --ATLASLOOT_PVP_70_A_DRUID_1 
    ["Grand Marshal's Wildhide"] = "Wildfell des Gro\195\159marschalls", --ATLASLOOT_PVP_70_A_DRUID_2 
    ["Grand Marshal's Refuge"] = "Zuflucht des Gro\195\159marschalls", --ATLASLOOT_PVP_70_A_DRUID_3 
    ["Grand Marshal's Pursuit"] = "Jagdtracht des Gro\195\159marschalls", --ATLASLOOT_PVP_70_A_HUNTER_1 
    ["Grand Marshal's Regalia"] = "Ornat des Gro\195\159marschalls", --ATLASLOOT_PVP_70_A_MAGE_1 
    ["Grand Marshal's Aegis"] = "Aegis des Gro\195\159marschalls", --ATLASLOOT_PVP_70_A_PALADIN_1 
    ["Grand Marshal's Vindication"] = "Rechtschaffenheit des Gro\195\159marschalls", --ATLASLOOT_PVP_70_A_PALADIN_2 
    ["Grand Marshal's Redemption"] = "Erl\195\182sung des Gro\195\159marschalls", --ATLASLOOT_PVP_70_A_PALADIN_3 
    ["Grand Marshal's Raiment"] = "Gewandung des Gro\195\159marschalls", --ATLASLOOT_PVP_70_A_PRIEST_1 
    ["Grand Marshal's Investiture"] = "Vereidigung des Gro\195\159marschalls", --ATLASLOOT_PVP_70_A_PRIEST_2 
    ["Grand Marshal's Vestments"] = "Gew\195\164nder des Gro\195\159marschalls", --ATLASLOOT_PVP_70_A_ROGUE_1 
    ["Grand Marshal's Earthshaker"] = "Erdersch\195\188tterer des Gro\195\159marschalls", --ATLASLOOT_PVP_70_A_SHAMAN_1 
    ["Grand Marshal's Thunderfist"] = "Donnerfaust des Gro\195\159marschalls", --ATLASLOOT_PVP_70_A_SHAMAN_2 
    ["Grand Marshal's Wartide"] = "Kriegsrausch des Gro\195\159marschalls", --ATLASLOOT_PVP_70_A_SHAMAN_3 
    ["Grand Marshal's Dreadgear"] = "Schreckensr\195\188stung des Gro\195\159marschalls", --ATLASLOOT_PVP_70_A_WARLOCK_1 
    ["Grand Marshal's Battlegear"] = "Schlachtr\195\188stung des Gro\195\159marschalls", --ATLASLOOT_PVP_70_A_WARRIOR_1 

    --PvP Level 70 Rare Sets - Horde
    ["High Warlord's Sanctuary"] = "Schutzgewandung des Obersten Kriegsf\195\188rsten", --ATLASLOOT_PVP_70_H_DRUID_1 
    ["High Warlord's Wildhide"] = "Wildfell des Obersten Kriegsf\195\188rsten", --ATLASLOOT_PVP_70_H_DRUID_2 
    ["High Warlord's Refuge"] = "Zuflucht des Obersten Kriegsf\195\188rsten", --ATLASLOOT_PVP_70_H_DRUID_3 
    ["High Warlord's Pursuit"] = "Jagdtracht des Obersten Kriegsf\195\188rsten", --ATLASLOOT_PVP_70_H_HUNTER_1 
    ["High Warlord's Regalia"] = "Ornat des Obersten Kriegsf\195\188rsten", --ATLASLOOT_PVP_70_H_MAGE_1 
    ["High Warlord's Aegis"] = "Aegis des Obersten Kriegsf\195\188rsten", --ATLASLOOT_PVP_70_H_PALADIN_1 
    ["High Warlord's Vindication"] = "Rechtschaffenheit des Obersten Kriegsf\195\188rsten", --ATLASLOOT_PVP_70_H_PALADIN_2 
    ["High Warlord's Redemption"] = "Erl\195\182sung des Obersten Kriegsf\195\188rsten", --ATLASLOOT_PVP_70_H_PALADIN_3 
    ["High Warlord's Raiment"] = "Gewandung des Obersten Kriegsf\195\188rsten", --ATLASLOOT_PVP_70_H_PRIEST_1 
    ["High Warlord's Investiture"] = "Vereidigung des Obersten Kriegsf\195\188rsten", --ATLASLOOT_PVP_70_H_PRIEST_2 
    ["High Warlord's Vestments"] = "Gew\195\164nder des Obersten Kriegsf\195\188rsten", --ATLASLOOT_PVP_70_H_ROGUE_1 
    ["High Warlord's Earthshaker"] = "Erdersch\195\188tterer des Obersten Kriegsf\195\188rsten", --ATLASLOOT_PVP_70_H_SHAMAN_1 
    ["High Warlord's Thunderfist"] = "Donnerfaust des Obersten Kriegsf\195\188rsten", --ATLASLOOT_PVP_70_H_SHAMAN_2 
    ["High Warlord's Wartide"] = "Kriegsrausch des Obersten Kriegsf\195\188rsten", --ATLASLOOT_PVP_70_H_SHAMAN_3 
    ["High Warlord's Dreadgear"] = "Schreckensr\195\188stung des Obersten Kriegsf\195\188rsten", --ATLASLOOT_PVP_70_H_WARLOCK_1 
    ["High Warlord's Battlegear"] = "Schlachtr\195\188stung des Obersten Kriegsf\195\188rsten", --ATLASLOOT_PVP_70_H_WARRIOR_1

    --Arena Season 1 - Epic Sets
    ["Gladiator's Sanctuary"] = "Schutzgewandung des Gladiators", --ATLASLOOT_ARENA_DRUID_1 
    ["Gladiator's Wildhide"] = "Wildfell des Gladiators", --ATLASLOOT_ARENA_DRUID_2 
    ["Gladiator's Refuge"] = "Zuflucht des Gladiators", --ATLASLOOT_ARENA_DRUID_3 
    ["Gladiator's Pursuit"] = "Jagdtracht des Gladiators", --ATLASLOOT_ARENA_HUNTER 
    ["Gladiator's Regalia"] = "Ornat des Gladiators", --ATLASLOOT_ARENA_MAGE 
    ["Gladiator's Aegis"] = "Aegis des Gladiators", --ATLASLOOT_ARENA_PALADIN_1 
    ["Gladiator's Vindication"] = "Rechtschaffenheit des Gladiators", --ATLASLOOT_ARENA_PALADIN_2 
    ["Gladiator's Redemption"] = "Erl\195\182sung des Gladiators", --ATLASLOOT_ARENA_PALADIN_3 
    ["Gladiator's Raiment"] = "Gewandung des Gladiators", --ATLASLOOT_ARENA_PRIEST_1 
    ["Gladiator's Investiture"] = "Vereidigung des Gladiators", --ATLASLOOT_ARENA_PRIEST_2 
    ["Gladiator's Vestments"] = "Gew\195\164nder des Gladiators", --ATLASLOOT_ARENA_ROGUE 
    ["Gladiator's Earthshaker"] = "Erdersch\195\188tterer des Gladiators", --ATLASLOOT_ARENA_SHAMAN_1 
    ["Gladiator's Thunderfist"] = "Donnerfaust des Gladiators", --ATLASLOOT_ARENA_SHAMAN_2 
    ["Gladiator's Wartide"] = "Kriegsrausch des Gladiators", --ATLASLOOT_ARENA_SHAMAN_3 
    ["Gladiator's Dreadgear"] = "Schreckensr\195\188stung des Gladiators", --ATLASLOOT_ARENA_WARLOCK_1 
    ["Gladiator's Felshroud"] = "Teufelsschleier des Gladiators", --ATLASLOOT_ARENA_WARLOCK_2 
    ["Gladiator's Battlegear"] = "Schlachtr\195\188stung des Gladiators", --ATLASLOOT_ARENA_WARRIOR 
    
    --Arena Season 2 - Epic Sets
    ["Merciless Gladiator's Sanctuary"] = "Schutzgewandung des erbarmungslosen Gladiators",
    ["Merciless Gladiator's Wildhide"] = "Wildfell des erbarmungslosen Gladiators",
    ["Merciless Gladiator's Refuge"] = "Zuflucht des erbarmungslosen Gladiators",
    ["Merciless Gladiator's Pursuit"] = "Jagdtracht erbarmungslosen des Gladiators",
    ["Merciless Gladiator's Regalia"] = "Ornat des erbarmungslosen Gladiators",
    ["Merciless Gladiator's Aegis"] = "Aegis des erbarmungslosen Gladiators",
    ["Merciless Gladiator's Vindication"] = "Rechtschaffenheit des erbarmungslosen Gladiators",
    ["Merciless Gladiator's Redemption"] = "Erl\195\182sung des erbarmungslosen Gladiators",
    ["Merciless Gladiator's Raiment"] = "Gewandung des erbarmungslosen Gladiators",
    ["Merciless Gladiator's Investiture"] = "Vereidigung des erbarmungslosen Gladiators",
    ["Merciless Gladiator's Vestments"] = "Gew\195\164nder des erbarmungslosen Gladiators",
    ["Merciless Gladiator's Earthshaker"] = "Erdersch\195\188tterer des erbarmungslosen Gladiators",
    ["Merciless Gladiator's Thunderfist"] = "Donnerfaust des erbarmungslosen Gladiators",
    ["Merciless Gladiator's Wartide"] = "Kriegsrausch des erbarmungslosen Gladiators",
    ["Merciless Gladiator's Dreadgear"] = "Schreckensr\195\188stung des erbarmungslosen Gladiators",
    ["Merciless Gladiator's Felshroud"] = "Teufelsschleier des erbarmungslosen Gladiators",
    ["Merciless Gladiator's Battlegear"] = "Schlachtr\195\188stung des erbarmungslosen Gladiators",
    
    --Set Labels
    ["Set: Embrace of the Viper"] = "Set: Umarmung der Viper (5 Teile)",  --ATLASLOOT_VIPERSET
    ["Set: Defias Leather"] = "Set: Defiasleder (5 Teile)",   --ATLASLOOT_DEFIASSET
    ["Set: The Gladiator"] = "Set: Der Gladiator (5 Teile)",  --ATLASLOOT_GLADIATORSET
    ["Set: Chain of the Scarlet Crusade"] = "Set: Kettenr\195\188stung des Scharlachroten Kreuzzugs",  --ATLASLOOT_SCARLETSET
    ["Set: The Postmaster"] = "Der Postmeister (5 Teile)",
    ["Set: Necropile Raiment"] = "Set: Roben des Totenbeschw\195\182rers (5 Teile)",
    ["Set: Cadaverous Garb"] = "Set: Leichenhaftes Gewand (5 Teile)",
    ["Set: Bloodmail Regalia"] = "Set: Ornat des Blutpanzers (5 Teile)",
    ["Set: Deathbone Guardian"] = "Set: W\195\164chter der Totengebeine (5 Teile)",
    ["Set: Dal'Rend's Arms"] = "Set: Dal'Rends Waffen (2 Teile)",
    ["Set: Spider's Kiss"] = "Set: Kuss der Spinne (2 Teile)",
    ["Temple of Ahn'Qiraj Sets"] = "Ahn'Qiraj Sets", --ATLASLOOT_AQ40_SETS
    ["AQ40 Class Sets"] = "AQ40-Klassen-Sets",  --ATLASLOOT_AQ40_CLASS_SET_PIECES_1
    ["Ruins of Ahn'Qiraj Sets"] = "Ruinen von Ahn'Qiraj Sets",  --ATLASLOOT_AQ20_SETS
    ["AQ20 Class Sets"] = "AQ20-Klassen-Sets",  --ATLASLOOT_AQ20_CLASS_SET_PIECES_1
    ["AQ Enchants"] = "AQ-Verzauberungen",  --ATLASLOOT_AQ_ENCHANTS
    ["AQ Opening Quest Chain"] = "AQ-\195\150ffnungsquestreihe",  --ATLASLOOT_AQ_OPENING
    ["Pre 60 Sets"] = "Sets (Low Level)",  --ATLASLOOT_PRE60_SETS
    ["Crafted Sets"] = "Sets (Berufe)",  --ATLASLOOT_CRAFTED_SETS
    ["Crafted Epic Weapons"] = "Geschmiedete epische Waffen",
    ["Zul'Gurub Sets"] = "Zul'Gurub Sets",  --ATLASLOOT_ZG_SETS
    ["ZG Class Sets"] = "ZG-Klassen-Sets",  --ATLASLOOT_ZG_CLASS_SET_PIECES_1
    ["ZG Enchants"] = "ZG-Verzauberungen",  --ATLASLOOT_ZG_ENCHANTS
    ["Arathi Basin Sets"] = "Arathibecken Sets",  --ATLASLOOT_FACTION_ARATHI_SETS
    ["PvP Rewards (Level 60)"] = "PvP-Belohnungen (Level 60)",
    ["PvP Rewards (Level 70)"] = "PvP-Belohnungen (Level 70)",
    ["PvP Accessories (Level 60)"] = "PvP-Zubeh\195\182r (Level 60)",
    ["PvP Accessories (Level 70)"] = "PvP-Zubeh\195\182r (Level 70)",
    ["PvP Rewards"] = "PvP-Belohnungen",  --ATLASLOOT_PVP_SET_PIECES_HEADER
    ["PvP Armor Sets"] = "PvP-R\195\188stungssets",  --ATLASLOOT_PVP_SETS, ATLASLOOT_PVP_SET_PIECES
    ["PvP Weapons"] = "PvP-Waffen",  --ATLASLOOT_PVP_WEAPONS
    ["PvP Accessories"] = "PvP-Zubeh\195\182r",  --ATLASLOOT_PVP_ACCESSORIES
    ["PvP Non-Set Epics"] = "PvP Nicht-Set Epics",  --ATLASLOOT_PVP_NONSET
    ["Arena PvP Weapons"] = "Arena PvP Waffen",  --ATLASLOOT_ARENA_WEAPONS
    ["Arena 2 PvP Weapons"] = "Arena 2 PvP Waffen",  --ATLASLOOT_ARENA_WEAPONS
    ["Season 1"] = "1. Saison",
    ["Season 2"] = "2. Saison",
    ["Class Books"] = "Klassenb\195\188cher",  --ATLASLOOT_CLASS_BOOKS
    ["Tribute Run"] = "Tribut Run",  --ATLASLOOT_TRIBUTE_RUN
    ["Dire Maul Books"] = "D\195\188sterbruch B\195\188cher", --ATLASLOOT_DM_BOOKS
    ["Random Boss Loot"] = "Zuf\195\164lliger Boss Loot",  --ATLASLOOT_RANDOM_LOOT
    ["Class Set Pieces"] = "Setteile",  --ATLASLOOT_CLASS_SET_PIECES
    ["Epic Set"] = "Episches Set",  --ATLASLOOT_PVP_EPIC_SET
    ["Rare Set"] = "Seltenes Set",  --ATLASLOOT_PVP_RARE_SET
    ["Legendary Items"] = "Legend\195\164re Items", --ATLASLOOT_LEGENDARIES
    ["Lvl 70 Instance Token Rewards"] = "Heroisch: Belohnungen",  --ATLASLOOT_HARDMODE
    ["Accesories and Weapons"] ="Zubeh\195\182r und Waffen",  --ATLASLOOT_HARDMODE_SUB1
    ["Fire Resistance Gear"] = "Feuerresistenz",  --ATLASLOOT_HARDMODE_SUB2
    ["Rare Mounts"] = "Seltene Reittiere",  --ATLASLOOT_RAREMOUNTS
    ["Tabards"] = "Wappenr\195\182cke",  --ATLASLOOT_TABARDS
    ["Token Hand-Ins"] = "Gutscheine",  --ATLASLOOT_FACTION_ARGENT_TOKEN
    ["Heroic Mode Keys"] = "Schl\195\188ssel: Heroisch",  --ATLASLOOT_BCKEYS_HEROIC
    
    --NPCs missing from BabbleBoss
    ["Dungeon Set 2 Summonable"] = "Beschworener Boss (DS2)",  --ATLASLOOT_DUNGEONSET2BOSS
    ["Highlord Kruul"] = "Hochlord Kruul",  --ATLASLOOT_HLKruul
    ["Sothos and Jarien"] = "Sothos und Jarien",  --ATLASLOOT_StratTwins
    ["Mor Grayhoof"] = "Mor Grauhuf", --ATLASLOOT_MorGray
    ["Druid of the Fang"] = "Druiden des Giftzahns", --ATLASLOOT_FANGDRUID
    ["Defias Strip Miner"] = "Akkordminenarbeiter der Defias", --ATLASLOOT_DEFIASMINER
    ["Defias Overseer/Taskmaster"] = "Vorarbeiter/Zuchtmeister der Defias",  --ATLASLOOT_DEFIASOVERSEER
    ["Scarlet Defender/Myrmidon"] = "Scharlachroter Myrmidone/Verteidiger",  --ATLASLOOT_SCARLETDEFENDER
    ["Scarlet Champion"] = "Scharlachroter Held",  --ATLASLOOT_SCARLETCHAMPION
    ["Scarlet Centurion"] = "Scharlachroter Zenturio",  --ATLASLOOT_SCARLETCENTURION
    ["Scarlet Trainee"] = "Scharlachroter Lehrling",  --ATLASLOOT_SCARLET_TRAINEE
    ["Scarlet Protector/Guardsman"] = "Scharlachroter Besch\195\188tzer/Gardist",  --ATLASLOOT_SCARLETPROTECTOR
    ["Eviscerator"] = "Ausweider",  --ATLASLOOT_BRDARENA2
    ["Shadowforge Flame Keeper"] = "Flammenbewahrer der Schattenschmiede",  --ATLASLOOT_BRD_FLAMEKEEPER
    ["Eric 'The Swift'"] = "Eric 'Der Flinke'",  --ATLASLOOT_ULD_ERIK
    ["Shadow of Doom"] = "Schatten der Verdammnis",  --ATLASLOOT_SINVASTION_SHADOWDOOM
    ["Bone Witch"] = "Knochenhexe",  --ATLASLOOT_SINVASTION_BONEWITCH
    ["Lumbering Horror"] = "Schwerf\195\164lliger Horror",  --ATLASLOOT_SINVASTION_LHORROR
    ["Avatar of the Martyred"] = "Avatar des Gemarterten",
    
    --Zones
    ["World Drop"] = "Weltdrops",

    --Chests, etc
    ["Chest of The Seven"] = "Truhe der Sieben",  --ATLASLOOT_BRDCHEST
    ["Dark Coffer"] = "Dunkler Kasten",  --ATLASLOOT_BRD_COFFER
    ["The Secret Safe"] = "Geheimsafe",  --ATLASLOOT_BRD_SAFE
    ["The Vault"] = "Der Tresor",  --ATLASLOOT_BRD_VAULT
    ["Ogre Tannin Basket"] = "Gerbekorb der Oger",  --ATLASLOOT_DM_TANNIN
    ["Fengus's Chest"] = "Fengus Truhe",  --ATLASLOOT_DM_FENGUS
    ["The Prince's Chest"] = "Die Truhe des Prinzen",  --ATLASLOOT_DM_PRINCE
    ["Doan's Strongbox"] = "Doans Geldkassette",  --ATLASLOOT_SCARLET_DOAN
    ["Frostwhisper's Embalming Fluid"] = "Frostraunens Balsamierungsfl\195\188ssigkeit", --ATLASLOOT_SCHOLO_FROSTWHISPER
    ["Unforged Rune Covered Breastplate"] = "Ungeschmiedete runenverzierte Brustplatte", --ATLASLOOT_UBRS_BREASTPLATE
    ["Malor's Strongbox"] = "Malors Geldkassette",  --ATLASLOOT_STRAT_STRONGBOX
    ["Unfinished Painting"] = "Unvollendetes Gem\195\164lde",  --ATLASLOOT_STRAT_PAINTING
    ["Felvine Shard"] = "Teufelsrankensplitter",  --ATLASLOOT_DM_FELVINE
    ["Baelog's Chest"] = "Baelogs Truhe", --ATLASLOOT_ULD_BAELOG_CHEST
    ["Lorgalis Manuscript"] = "Manuskript von Lorgalis",
    ["Fathom Core"] = "Tiefenkern",
    ["Conspicuous Urn"] = "Verd\195\164chtige Urne",
    
--World Events
    ["Children's Week"] = "Kinderwoche",
    ["Elemental Invasion"] = "Invasion der Elementare",
    ["Gurubashi Arena"] = "Gurubashiarena", -- NOTE: two different possibilities @ wow-europe.com/de...
    ["Stranglethorn Fishing Extravaganza"] = "Anglerwettbewerb im Schlingendorntal",
    
} end)


----------------------------------------------------------------------------------
--    : \195\160     : \195\168     : \195\172     : \195\178     : \195\185
--    : \195\161     : \195\169     : \195\173     : \195\179     : \195\186
--    : \195\162     : \195\170     : \195\174     : \195\180     : \195\187
--    : \195\163     : \195\171     : \195\175     : \195\181     : \195\188
--    : \195\164                     : \195\177     : \195\182
--    : \195\166                                     : \195\184
--    : \195\167
--
--    : \195\132
--    : \195\150
--    : \195\156
--    : \195\159